#pragma once

#include "SFML/Graphics.hpp"
#include "ComponentSystem.h"

struct RenderProperties
{
	sf::Texture texture;
	sf::Sprite sprite;

	//Constructor
	RenderProperties()
	{ }

	//Copy assignment constructor
	RenderProperties& operator=(const RenderProperties& other)
	{
		texture = sf::Texture(other.texture);
		sprite = sf::Sprite(other.sprite);

		sprite.setTexture(texture);

		return *this;
	}

	//Copy Constructor
	RenderProperties(const RenderProperties& other)
	{
		texture = sf::Texture(other.texture);
		sprite = sf::Sprite(other.sprite);

		sprite.setTexture(texture);
	}

	//Move constructor
	RenderProperties(RenderProperties&& other) noexcept
	{
		texture = sf::Texture(other.texture);
		sprite = sf::Sprite(other.sprite);
		sprite.setTexture(texture);

		other.texture = sf::Texture();
		other.sprite = sf::Sprite();
	}
};

class RenderSystem : public ComponentSystemBase
{
public: 

	RenderSystem();

	virtual void Update(float deltaSeconds) override;

	sf::RenderWindow& GetWindow() 
	{
		return m_myWindow; 
	}

private:

	sf::RenderWindow m_myWindow;
};